const {response, request} = require('express');
const axios = require('axios');


const getIdentityCard = async(req = request, res = response ) => {
  const {cedula} = req.params;
  try {
    // Haciendo la solicitud HTTP a la API que no tiene SSL
    const apiResponse = await axios.get(`http://pichincha.gapsystem.net:10048/api/services/cedulaV2/${cedula}`); 
    //console.log(apiResponse.data.consulta);
    res.json({
      ok: true,
      data: apiResponse.data.consulta
    });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      ok: false,
      msg: 'No se puede acceder al servidor central.'
    });
  }

}

const getCompanyRuc = async(req = request, res = response ) => {
  const {ruc} = req.params;
  try {
    const apiResponse = await axios.get(`http://pichincha.gapsystem.net:10048/api/services/ruc/${ruc}`);
    if (
      apiResponse.data?.consulta?.mensajeServidor?.texto === 'Acceso denegado' || 
      apiResponse.data?.consulta?.data?.length === 0
    ) {
      await getCompanyRuc(req,res); // Volver a intentar
      return;
    }
    res.json({
      ok: true,
      data: apiResponse.data.consulta[0]
    });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      ok: false,
      msg: 'No se puede acceder al servidor central.'
    });
  }
}

module.exports = {
  getIdentityCard,
  getCompanyRuc
}