const {response, request} = require('express');
const bcrypt = require('bcryptjs');
const {Op} = require('sequelize');

const {db} = require('../tables_db/init-models');
const { generarJWT } = require('../helpers/trigger-JWT');
const { validateLicense } = require('../middlewares/validate-fields');
const { getMenuFrontEnd } = require('../helpers/menu-front');

const User = db.Users;
const License=db.License;
/* *************************************************************** */
/* **********************Services GET***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const Auth = async (req = request, res = response ) => { 

    const { email, password } = req.body;

    try {

        const user = await User.findOne({ 
            where:{email},
            attributes: ['id_user', 'id_role', 'id_company', 'email', 'user_password', 'name_person', 'address_person', 'phone_person', 'img', 'status_user', 'create_time', 'specialty', 'document_number'] // solo los campos necesarios
        });

        if(!user){
            return res.status(401).json({
                ok: false,
                msg: 'Usuario/Contraseña incorrectos.'
            });
        }else{
            if(user.status_user === 0){
                return res.status(403).json({
                    ok: false,
                    msg: 'El usuario se encuentra inactivo.'
                });
            }
        }

        const validPassword = bcrypt.compareSync(password, user.user_password);
        if(!validPassword){
            return res.status(401).json({
                ok: false,
                msg: 'Usuario/Contraseña incorrectos.'
            });
        }

        const license = await License.findOne({
            attributes:['expiration_date'],
            where :{
                [Op.and]:[
                    {id_company: user.id_company}
                ]
                },
                order: [
                ['expiration_date', 'DESC']
            ],
            });

        if(license){
            let actualDate = new Date();
            actualDate.setHours(0, 0, 0, 0);
            let actualDate2 = new Date(license.dataValues.expiration_date);
            actualDate2.setHours(0, 0, 0, 0);
            if(actualDate2 < actualDate ){                    
                
                //Si la licencia ha expirado se devuelve el ultimo registro de licencias emitido
                const existData = await License.findOne({
                where :{
                    [Op.and]:[
                        {id_company: user.id_company},
                        {status_license: 1}
                    ]
                },
                order: [
                    ['expiration_date', 'DESC']
                ],
                });
                

                if(!existData){
                    return res.status(401).json({
                        ok: false,
                        msg: 'Su licencia de uso a expirado.'
                    });
                }
                
                await existData.update({status_license:0 });
                return res.status(401).json({
                    ok: false,
                    msg: 'Su licencia de uso a expirado.'
                });
            }
        }else{
            return res.status(401).json({
                ok: false,
                msg: 'Aun no cuenta con licencia de uso de la aplicación.'
            });
        }

        //?Genero JWT
        const token = await generarJWT( user.id_user );

        return res.json({
            ok: true,
            user,
            token,
            menu: getMenuFrontEnd()
        });

    } catch (error) {
        console.log(error);
        return res.status(500).json({
            ok:false,
            msg: error
        });
    }
};

const renewToken = async(req, res = response) => {

    // Generar el TOKEN - JWT
    const token = await generarJWT( req.uid );

    // Obtener el usuario por UID
    const user = await User.findByPk( req.uid );


    res.json({
        ok: true,
        user,
        token,
        menu: getMenuFrontEnd()
    });

}
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
    Auth,
    renewToken
}
/* *************************************************************** */
/* *************************************************************** */