const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Bill = db.Bill;
const Box = db.Boxes;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getBill = async (req = request, res = response ) => { 

  const id_company = req.company;
  const {page, limit} = req.query;
  if(!page ){
    page = 1;
  }
  if(!limit ){
    limit=10;
  }
  try {

    const box = await Box.findAll({
      where:{
        id_company
      }
    });

    if(box){
      let bills = [];
      box.forEach(element => {
        const bill = Bill.findAll({
          attributes:['id_bill', 'business_name', 'address_bill', 'email', 'phone', 'total', 'create_time'],
          where:{
            id_box : element.id_box
          }
        })
        bills.push(bill);
      });
      return res.json({
        ok: true,
        bills
      });
    }

    return res.status(200).json({
      ok:false,
      msg:'No Existe facturas para mostrar'
    });


  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postBill = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    //Validar que no exista otra data igual
    const existData = await Bill.findOne({
      where :{
        [Op.and]:[
          {}
        ]
    }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`Ya existe la información que desea ingresar.`
      });
    }

    const newBill = new Bill( body );
    await newBill.save();

  return res.json({
    ok: true,
    newBill
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {}
/* *************************************************************** */
/* *************************************************************** */