
const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Blood = db.BloodTyping;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getBlood = async (req = request, res = response ) => { 
  try {

  const blood = await Blood.findAll({
    where:{status_blood_typing: 1}
  });

  return res.json({
    ok: true,
    blood
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postBlood = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    //Validar que no exista otra data igual
    const existData = await Blood.findOne({
      where :{
      detail : body.detail
    }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`El tipo de sangre ${body.detail}, ya fue registrado.`
      });
    }

    const newBlood = new Blood( body );
    await newBlood.save();

  return res.json({
    ok: true,
    newBlood
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putBlood = async (req = request, res = response ) => { 

  const { id } = req.params.id;
  let { detail } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await Blood.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({detail});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

const deleteBlood = async (req = request, res = response ) => { 

  const { id } = req.params.id;

  try {

    //Validar que exista la data para eliminar
    const existData = await Blood.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({status_blood_typing: 0});

    return res.json({
      ok: true,
      msg: 'Información Object con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getBlood,
  postBlood,
  putBlood,
  deleteBlood
}
/* *************************************************************** */
/* *************************************************************** */