const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Cie = db.Cie;



/* *************************************************************** */
/* **********************Services GET***************************** */

const getCie = async (req = request, res = response ) => { 

  const id = req.params.id;
  try {
    let {page, limit} = req.query;
    if(!page || !limit){
      page = 1;
      limit=50;
    }

    const cie = await Cie.findAll({
      attributes:[ 'four_characters', 'secondary_name', 'main_name'],
      where: {
        [Op.or]:[
          {
            four_characters:{
              [Op.like]:`%${id}%`
            }
          },
          {
            secondary_name:{
              [Op.like]:`%${id}%`
            }
          },
          {
            main_name:{
              [Op.like]:`%${id}%`
            }
          }
        ]
      },
      order: [
        ['four_characters', 'ASC']
      ],
      limit: parseInt(limit),
      offset: (page - 1) * limit
    });

    return res.json({
      ok: true,
      cie
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getCie
}
/* *************************************************************** */
/* *************************************************************** */