const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Consulting = db.ConsultingRoom;
const Company = db.Company;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getConsulting = async (req = request, res = response ) => { 
  const id_company = req.company;
  try {

  const consulting = await Consulting.findAll({
    where: {
      id_company,
      status_consulting: 1
    }
  });

  return res.json({
    ok: true,
    consulting
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: 'No hay comunicación con el servidor principal.'
    });
  }
};
const getConsultingByPk = async (req = request, res = response ) => { 
  const id_company = req.company;
  const id_consulting = req.params.id;
  try {

    const consulting = await Consulting.findOne({
      where: {
        id_company,
        id_consulting,
        status_consulting: 1
      }
    });

    return res.json({
      ok: true,
      consulting
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: 'No hay comunicación con el servidor principal.'
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postConsulting = async (req = request, res = response ) => { 

  const { body } = req;
  body.id_company = req.company;

  try {

    //Validar que no exista otra data igual
    const existData = await Consulting.findOne({
      where :{
      name_consulting : body.name_consulting,
      id_company: body.id_company
    }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`Consultorio ya existe con la nomenclatura ingresada.`
      });
    }

    const newConsulting = new Consulting( body );
    await newConsulting.save();

    return res.json({
      ok: true,
      newConsulting,
      msg: 'Consultorio creado con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putConsulting = async (req = request, res = response ) => { 

  let { id_consulting,
        name_consulting,
        details } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await Consulting.findByPk( id_consulting );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`Consultorio solicitado no existe.`
      });
    }

    await existData.update({name_consulting, details});

    return res.json({
      ok: true,
      msg: 'Información de consultorio actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

const deleteConsulting = async (req = request, res = response ) => { 

  const id = req.params.id;

  try {

    //Validar que exista la data para actualizar
    const existData = await Consulting.findByPk( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe el consultorio a ser eliminado.`
      });
    }

    await existData.update({status_consulting: 0});

    return res.json({
      ok: true,
      msg: 'Eliminado con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getConsulting,
  getConsultingByPk,
  postConsulting,
  putConsulting,
  deleteConsulting
}
/* *************************************************************** */
/* *************************************************************** */