const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Customer = db.Customer;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getCustomer = async (req = request, res = response ) => { 

  const number_document = req.params.id;
  try {

    const customer = await Customer.findOne({
      where: {
        number_document
      }
    });

    return res.json({
      ok: true,
      customer
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postCustomer = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    //Validar que no exista otra data igual
    const existData = await Customer.findOne({
      where :{
      number_document : body.number_document
    }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`Ya existe la información que desea ingresar.`
      });
    }

    const newCustomer = new Customer( body );
    await newCustomer.save();

  return res.json({
    ok: true,
    newCustomer
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getCustomer,
  postCustomer
}
/* *************************************************************** */
/* *************************************************************** */