const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Evolution = db.Evolution;
const Attention = db.Attention;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getEvolution = async (req = request, res = response ) => { 

  const id_attention = req.params.id;
  try {

  const evolution = await Evolution.findOne({
    where:{
      id_attention
    }
  });

  return res.json({
    ok: true,
    evolution
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postEvolution = async (req = request, res = response ) => { 

  const { body } = req;
  body.id_user = req.uid;

  try {

    const existData = await Evolution.findOne({
      where:{
        id_attention: body.id_attention
      }
    })

    if(existData){
      await existData.update({evolution: body.evolution, prescriptions: body.prescriptions});
      return res.json({
        ok: true,
        msg: 'Evolución actualizada con éxito.'
      })
    }

    const newEvolution = new Evolution( body );
    await newEvolution.save();

  return res.json({
    ok: true,
    msg: 'Evolución Guardada con éxito.'
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getEvolution,
  postEvolution
}
/* *************************************************************** */
/* *************************************************************** */