const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Exam = db.Exams;
const Attention = db.Attention;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getExam = async (req = request, res = response ) => { 

  const id_attention = req.params.id;

  try {

  const exam = await Exam.findAll({
    where:{
      id_attention
    }
  });

  return res.json({
    ok: true,
    exam
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};
const getExamByPatient = async (req = request, res = response ) => { 

  const id_patient = req.params.id;

  try {

    const attention = await Attention.findAll({
      attributes:[ 'id_attention' ],
      where:{
        id_patient
      }
    })

    if(!attention){
      return res.status(404).json({
        ok: false,
        msg: 'No hay exámenes solicitados para este paciente.'
      });
    }

    
    let id_attention=[];
    attention.forEach(element => {
      id_attention.push(element.dataValues.id_attention);
    });

    const exam = await Exam.findAll({
      where:{
        id_attention
      },
      order: [
        ['create_time', 'DESC']
    ]
    });

    return res.json({
      ok: true,
      exam
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postExam = async (req = request, res = response ) => { 

  const { body } = req;
  try {

    const id_attention = body.dynamics[0].id_attention
    await Exam.destroy({
      where: {
        id_attention
      }
    });
    body.dynamics.forEach(async element => {
      
      const newExam = new Exam( element );
      newExam.id_user = req.uid;
      newExam.save();
      
    });

    const exam = await Exam.findAll({
      where:{
        id_attention
      }
    });

    return res.json({
      ok: true,
      msg:'Exámenes guardados con éxito.',
      exam
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putExam = async (req = request, res = response ) => { 

  const { id } = req.params.id;
  let { exam_detail, exam_url } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await Exam.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({exam_detail, exam_url});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

const deleteExam = async (req = request, res = response ) => { 

  const { id } = req.params.id;

  try {

    //Validar que exista la data para eliminar
    const existData = await Exam.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser eliminada.`
      });
    }

    await existData.update({status_exam: 0});

    return res.json({
      ok: true,
      msg: 'Información eliminada con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getExam,
  postExam,
  putExam,
  deleteExam,
  getExamByPatient
}
/* *************************************************************** */
/* *************************************************************** */