const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Habit = db.Habits;
const Attention = db.Attention;
/* *************************************************************** */
/* **********************Services GET***************************** */

const getHabitByPatient = async (req = request, res = response ) => { 
  const id_patient = req.params.id;
  try {

  const habits = await Habit.findAll({
    where:{
      id_patient
    }
  });

  return res.json({
    ok: true,
    habits
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postHabit = async (req = request, res = response ) => { 

  const { body } = req;
  body.id_user = req.uid;

  try {

    const newHabit = new Habit( body );
    await newHabit.save();

  return res.json({
    ok: true,
    newHabit
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putHabit = async (req = request, res = response ) => { 

  const { id } = req.params.id;
  let { descriptions } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await Habit.findByPk( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({descriptions});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getHabitByPatient,
  postHabit,
  putHabit
}
/* *************************************************************** */
/* *************************************************************** */