const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');
const { parse } = require('date-fns');

const License = db.License;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getLicense = async (req = request, res = response ) => { 

  const id_company = req.company || 1;
  try {

    let license = await License.findOne({
      attributes:['expiration_date'],
      where :{
        [Op.and]:[
          {id_company},
          {status_license: 1}
        ]
      },
      order: [
        ['expiration_date', 'DESC']
    ],
    });

    if(license.dataValues.expiration_date){
      const actualDate = new Date();
      const actualDate2 = new Date(license.dataValues.expiration_date);
      if(actualDate2 >= actualDate ){
        return res.json({
          ok: true
        });
      }else{
        //Si la licencia ha expirado se devuelve el ultimo registro de licencias emitido
        const existData = await License.findOne({
          where :{
            [Op.and]:[
              {id_company},
              {status_license: 1}
            ]
          },
          order: [
            ['expiration_date', 'DESC']
        ],
        });

        await existData.update({status_license:0 });
      }
    }

    return res.json({
      ok: false
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

const getLicenseByPk = async (req = request, res = response ) => { 

  const {id} = req.params;

  try {

  const licenses = await License.findAll({
    where:{
      id_company: id
    }
  });

  return res.json({
    ok: true,
    licenses
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postLicense = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    const newLicense = new License( body );
    await newLicense.save();

  return res.json({
    ok: true,
    newLicense
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putLicense = async (req = request, res = response ) => { 

  const { id } = req.params.id;
  let { status_license } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await License.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({status_license: 0});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getLicense,
  getLicenseByPk,
  postLicense,
  putLicense
}
/* *************************************************************** */
/* *************************************************************** */