const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const OrganSystem = db.OrganSystemsReview;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getOrgan = async (req = request, res = response ) => { 
  const id_patient = req.params.id
  try {

  const organ = await OrganSystem.findAll({
    where:{
      id_patient
    }
  });

  return res.json({
    ok: true,
    organ
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postOrgan = async (req = request, res = response ) => { 

  const { body } = req;
  body.id_user = req.uid;

  try {

      
    const newOrgan = new OrganSystem( body );
    await newOrgan.save();

    const organ = await OrganSystem.findAll({
      where:{
        id_patient: body.id_patient
      }
    });

  return res.json({
    ok: true,
    organ
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putOrgan = async (req = request, res = response ) => { 

  const { id } = req.params.id;
  let { detail } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await OrganSystem.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({detail});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getOrgan,
  postOrgan,
  putOrgan
}
/* *************************************************************** */
/* *************************************************************** */