const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Pathological = db.PathologicalBackground;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getPathological = async (req = request, res = response ) => { 
  const id_patient = req.params.id
  try {
  const pathological = await Pathological.findAll({
    where:{
      id_patient
    }
  });

  return res.json({
    ok: true,
    pathological
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postPathological = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    const newPathological = new Pathological( body );
    newPathological.id_user = req.uid;
    await newPathological.save();

    const pathological = await Pathological.findAll({
      where:{
        id_patient: body.id_patient
      }
    })

    return res.json({
      ok: true,
      pathological
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putPathological = async (req = request, res = response ) => { 

  const { id } = req.params.id;
  let { detail } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await Pathological.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({detail});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

const deletePathological = async (req = request, res = response ) => { 

  const { id } = req.params.id;

  try {

    //Validar que exista la data para eliminar
    const existData = await Pathological.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser eliminada.`
      });
    }

    await existData.update({status_pathological_background: 0});

    return res.json({
      ok: true,
      msg: 'Información eliminada con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getPathological,
  postPathological,
  putPathological,
  deletePathological
}
/* *************************************************************** */
/* *************************************************************** */