const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');
const { PrescriptionPDF } = require('../helpers/Pres_PDF');

const Prescription = db.Prescription;
const Attention = db.Attention;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getPrescription = async (req = request, res = response ) => { 
  const id_attention = req.params.id;
  try {

  const prescriptions = await Prescription.findAll({
    where:{id_attention}
  });

  return res.json({
    ok: true,
    prescriptions
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postPrescription = async (req = request, res = response ) => { 

  const { body } = req;
  const id_attention = req.params.id;

  try {

    let newPrescription;
    body.dynamics.forEach( async element => {
      newPrescription = new Prescription( element );
      newPrescription.id_user = req.uid;
      newPrescription.id_attention = id_attention;
      await newPrescription.save();
    });

    return res.json({
      ok: true,
      newPrescription,
      id_attention
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getPrescription,
  postPrescription
}
/* *************************************************************** */
/* *************************************************************** */