const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const ReasonConsultation = db.ReasonConsultation;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getReason = async (req = request, res = response ) => { 

  const id_attention = req.params.id;
  try {

  const reason = await ReasonConsultation.findOne({
    where:{
      id_attention
    }
  });

  return res.json({
    ok: true,
    reason
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postReason = async (req = request, res = response ) => { 

  const { body } = req;

  body.id_user = req.uid;

  try {

    //Validar que no exista otra data igual
    const existData = await ReasonConsultation.findOne({
      where :{
        id_attention : body.id_attention
    }
    });

    if(existData){
      let { reason, disease } = req.body;
      await existData.update({reason, disease});
      return res.json({
        ok: true,
      msg: 'Información actualizada con éxito.',
      });
    }

    const newReason = new ReasonConsultation( body );
    await newReason.save();

  return res.json({
    ok: true,
    newReason
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putReason = async (req = request, res = response ) => { 

  const  id_attention  = req.params.id;
  let { reason, disease } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await ReasonConsultation.findOne({id_attention});

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({reason, disease});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

const deleteReason = async (req = request, res = response ) => { 

  const { id } = req.params.id;

  try {

    //Validar que exista la data para eliminar
    const existData = await ReasonConsultation.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser eliminada.`
      });
    }

    await existData.update({status_reason_consultation: 0});

    return res.json({
      ok: true,
      msg: 'Información eliminada con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getReason,
  postReason,
  putReason,
  deleteReason
}
/* *************************************************************** */
/* *************************************************************** */