
const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Role = db.Roles;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getRole = async (req = request, res = response ) => { 
  try {

  const role = await Role.findAll();

  return res.json({
    ok: true,
    role
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

const getRoleById = async (req = request, res = response ) => { 
  const {id} = req.params;
  try {

  const role = await Role.findByPk(id);

  return res.json({
    ok: true,
    role
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postRole = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    //Validar que no exista otra data igual
    const existData = await Role.findOne({
      where :{
      detail : body.detail
    }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`Ya existe el rol que desea ingresar.`
      });
    }

    const newRole = new Role( body );
    await newRole.save();

  return res.json({
    ok: true,
    newRole
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putRole = async (req = request, res = response ) => { 

  const { id } = req.params;
  let { detail, description_role } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await Role.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`El rol no existe o su identificador esta incorrecto.`
      });
    }

    await existData.update({detail, description_role});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

const deleteRole = async (req = request, res = response ) => { 

  const { id } = req.params.id;

  try {

    //Validar que exista la data para actualizar
    const existData = await Role.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({status_role: 0});

    return res.json({
      ok: true,
      msg: 'Rol eliminado con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getRole,
  getRoleById,
  postRole,
  putRole,
  deleteRole
}
/* *************************************************************** */
/* *************************************************************** */