const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Tooth = db.Tooth

/* *************************************************************** */
/* **********************Services GET***************************** */

const getToothAdult = async (req = request, res = response ) => { 
  try {

    const upperTooth = await Tooth.findAll({
      where:{ 
        adult: 1,
        positions: 1
      },
      order:[['orders','ASC']]   //Ordena de menor a mayor por ID
    });
    const lowerTooth = await Tooth.findAll({
      where:{ 
        adult: 1,
        positions: 0
      },
      order:[['orders','ASC']] 
    });

    return res.json({
      ok: true,
      upperTooth,
      lowerTooth
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

const getToothChild = async (req = request, res = response ) => { 
  try {

    const upperTooth = await Tooth.findAll({
      where:{ 
        adult: 0,
        positions: 1
      }
    });
    const lowerTooth = await Tooth.findAll({
      where:{ 
        adult: 0,
        positions: 0
      }
    });

    return res.json({
      ok: true,
      upperTooth,
      lowerTooth
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postTooth = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    //Validar que no exista otra data igual
    const existData = await Tooth.findOne({
      where :{
        dental_piece : body.dental_piece
      }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`nombre de diente ya fue registrado.`
      });
    }

    const newTooth = new Tooth( body );
    await newTooth.save();

  return res.json({
    ok: true,
    newTooth
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getToothAdult,
  getToothChild,
  postTooth,
}
/* *************************************************************** */
/* *************************************************************** */