const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Attention = db.Attention;
const Patient = db.Patient;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getAttentionPatient = async (req = request, res = response ) => { 
  const document_number = req.params.id;
  try {

  const result = await Attention.findAll({
    attributes: ['id_attention', 'status_attention', 'create_time'],
    include: [{
      model: Patient,
      as:'patient',
      attributes: ['document_number'],
      where: {
        document_number
      }
    }]
  });

  const formattedResults = result.map(item => ({
    id_attention: item.id_attention,
    status_attention: item.status_attention,
    create_time: item.create_time,
    document_number: item.patient.document_number
  }));

  return res.json({
    ok: true,
    formattedResults
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getAttentionPatient
}
/* *************************************************************** */
/* *************************************************************** */