const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const TypeID = db.TypeID;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getTypeID = async (req = request, res = response ) => { 
  try {

  const typeId = await TypeID.findAll();

  return res.json({
    ok: true,
    typeId
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postTypeId = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    //Validar que no exista otra data igual
    const existData = await TypeID.findOne({
      where :{
      detail : body.detail
    }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`Ya existe la información que desea ingresar.`
      });
    }

    const newTypeId = new TypeID( body );
    await newTypeId.save();

  return res.json({
    ok: true,
    newTypeId
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putTypeId = async (req = request, res = response ) => { 

  const { id } = req.params.id;
  let { detail, description_type_id, code_type_id } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await TypeID.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({detail, description_type_id, code_type_id});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

const deleteTypeId = async (req = request, res = response ) => { 

  const { id } = req.params.id;

  try {

    //Validar que exista la data para eliminar
    const existData = await TypeID.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser eliminada.`
      });
    }

    await existData.update({status_type_id: 0});

    return res.json({
      ok: true,
      msg: 'Información eliminada con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getTypeID,
  postTypeId,
  putTypeId,
  deleteTypeId
}
/* *************************************************************** */
/* *************************************************************** */