const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const VitalSigns = db.VitalSigns

/* *************************************************************** */
/* **********************Services GET***************************** */

const getVitalSigns = async (req = request, res = response ) => { 
  const id_attention = req.params.id;
  try {

  const vitalSigns = await VitalSigns.findOne({
    where:{id_attention}
  });

  return res.json({
    ok: true,
    vitalSigns
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postVitalSigns = async (req = request, res = response ) => { 

  const { body } = req;
  body.id_user = req.uid;
  try {

    //Validar que no exista otra data igual
    const existData = await VitalSigns.findOne({
      where :{
        id_attention : body.id_attention
    }
    });

    if(existData){
      // return res.status(409).json({
      //   ok: false,
      //   msg:`Signos vitales para esta atención ya fueron almacenados.`
      // });
      let { temperature, bloodPressureA, bloodPressureB, pulse, breathingFrequency, weight, size, imc, abdominalPerimeter, hemoglobin, glucose, pulsioximetria } = req.body;
      await existData.update({temperature, bloodPressureA, bloodPressureB, pulse, breathingFrequency, weight, size, imc, abdominalPerimeter, hemoglobin, glucose, pulsioximetria});
      return res.json({
        ok: true,
      msg: 'Información actualizada con éxito.',
      });
    }

    const newVitalSigns = new VitalSigns( body );
    await newVitalSigns.save();

  return res.json({
    ok: true,
    newVitalSigns
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putVitalSings = async (req = request, res = response ) => { 

  const { id } = req.params.id;
  let { temperature, bloodPressureA, bloodPressureB, pulse, breathingFrequency, weight, size, imc, abdominalPerimeter, hemoglobin, glucose, pulsioximetria } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await VitalSigns.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({temperature, bloodPressureA, bloodPressureB, pulse, breathingFrequency, weight, size, imc, abdominalPerimeter, hemoglobin, glucose, pulsioximetria});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

const deleteVitalSigns = async (req = request, res = response ) => { 

  const { id } = req.params.id;

  try {

    //Validar que exista la data para eliminar
    const existData = await VitalSigns.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser eliminada.`
      });
    }

    await existData.update({status_vital_signs: 0});

    return res.json({
      ok: true,
      msg: 'Información eliminada con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getVitalSigns,
  postVitalSigns,
  putVitalSings,
  deleteVitalSigns
}
/* *************************************************************** */
/* *************************************************************** */