const {response, request} = require('express');
const fs = require('fs');

const {db} = require('../tables_db/init-models');

const User = db.Users;
const Companies = db.Company;
const Patient = db.Patient;
const Exam = db.Exams;

const updateImage = async( type, id, fileName ) => {

  switch (type) {
    case 'users':
        const user = await User.findByPk(id);
        if(!user){
          return false;
        }

        if(user.img !== ''){
          const oldPath = `./uploads/users/${user.img}`
          if(fs.existsSync(oldPath)){
            fs.unlinkSync(oldPath);
          }
        }

        await user.update({img: fileName});
        return true;

      break;
    case 'companies':
      
      const company = await Companies.findByPk(id);
      if(!company){
        return false;
      }
      if(company.logo !== ''){
        const oldPathQ = `./uploads/companies/${company.logo}`
        if(fs.existsSync(oldPathQ)){
          fs.unlinkSync(oldPathQ);
        }
      }


      await company.update({logo: fileName});
      return true;

      break;
    case 'patient':
      
        const patient = await Patient.findByPk(id);
        if(!patient){
          return false;
        }
        if(patient.photo !== ''){
          const oldPathA = `./uploads/patient/${patient.photo}`

          if(fs.existsSync(oldPathA)){
            fs.unlinkSync(oldPathA);
          }
        }
        await patient.update({photo: fileName});
        return true;

      break;
    case 'pdf':
      
        const exam = await Exam.findByPk(id);
        if(!exam){
          return false;
        }
        if(exam.exam_url !== ''){
          const oldPathU = `./uploads/pdf/${exam.exam_url}`

          if(fs.existsSync(oldPathU)){
            fs.unlinkSync(oldPathU);
          }
        }
        await exam.update({exam_url: fileName});
        return true;
      break;
  
    default:
      break;
  }

}


module.exports = {
  updateImage
}