const { response, request } = require('express');
const jwt = require('jsonwebtoken');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const User = db.Users;
const Person = db.Person;
const License = db.License;


const validateJWT = async ( req = request, res = response, next) => {

    const token = req.header('x-token');

    if(!token){
        return res.status(401).json({
            ok: false,
            msg: 'No existe Token en la petición.'
        });
    }

    try {

        const { uid } = jwt.verify( token, 'U6#T2c@kZ*L9i$rP0&S3y@hV7!oL1eR8%bN4q^mF5gI$jX1*pA');
        req.uid = uid;

        const user = await User.findByPk( uid );

        if(!user){
            return res.status(401).json({
                ok:false,
                msg: "JWT invalido."
            });
        }

        if(!user.status_user){
            return res.status(401).json({
                ok:false,
                msg: "JWT invalido."
            });
        }

        req.role = user.id_role;
        req.company = user.id_company;
        
        const license = await License.findOne({
            attributes:['expiration_date'],
            where :{
                [Op.and]:[
                    {id_company: user.id_company}
                ]
                },
                order: [
                ['expiration_date', 'DESC']
            ],
            });

        if(license){
            let actualDate = new Date();
            actualDate.setHours(0, 0, 0, 0);
            let actualDate2 = new Date(license.dataValues.expiration_date);
            actualDate2.setHours(0, 0, 0, 0);
            if(actualDate2 < actualDate ){                    
                
                //Si la licencia ha expirado se devuelve el ultimo registro de licencias emitido
                const existData = await License.findOne({
                where :{
                    [Op.and]:[
                        {id_company: req.company},
                        {status_license: 1}
                    ]
                },
                order: [
                    ['expiration_date', 'DESC']
                ],
                });
                

                if(!existData){
                    return res.status(401).json({
                        ok: false,
                        msg: 'Su licencia de uso a expirado.'
                    });
                }
                
                await existData.update({status_license:0 });
                return res.status(401).json({
                    ok: false,
                    msg: 'Su licencia de uso a expirado.'
                });
            }
        }else{
            return res.status(401).json({
                ok: false,
                msg: 'Aun no cuenta con licencia de uso de la aplicación.'
            });
        }

        next();
    } catch (error) {
        console.log(error);
        return res.status(401).json({
            ok: false,
            msg: 'JWT invalido...'
        });
    }


}


module.exports = {
    validateJWT
}