const express = require('express');
const cors = require('cors');
const db = require('../db/connection');


class Server{

    constructor(){
        this.app = express();
        this.port = 8090;
        
        //?Conexión a la Base de datos
        this.dbConnection();

        //?Middlewares
        this.middlewares();

        //?Rutas de mi aplicación
        this.routes();

    }

    async dbConnection(){
        try {
            
            await db.authenticate();
            console.log('Base de datos conectada con éxito');

        } catch (error) {
            console.log(error);
        }
    }

    //!middlewares
    middlewares() {
        
        //? CORS
        this.app.use( cors() );

        //? Parseo y Lectura del BODY
        this.app.use( express.json() );

        //? Servir contenido estático
        this.app.use(express.static('public'))
    }

    routes(){

        this.app.use('/api/auth', require('../routes/auth.route'));
        this.app.use('/api/uploads', require('../routes/uploads.route'));

        this.app.use('/api/attention', require('../routes/attention.route'));
        this.app.use('/api/blood', require('../routes/blood.route'));
        this.app.use('/api/box', require('../routes/boxes.route'));
        this.app.use('/api/cie', require('../routes/cie.route'));
        this.app.use('/api/civilStatus', require('../routes/civilStatus.route'));
        this.app.use('/api/company', require('../routes/company.route'));
        this.app.use('/api/consulting', require('../routes/consulting.route'));
        this.app.use('/api/customer', require('../routes/customer.route'));
        this.app.use('/api/diagnosis', require('../routes/diagnosis.route'));
        this.app.use('/api/diary', require('../routes/diary.route'));
        this.app.use('/api/disability', require('../routes/disability.route'));
        this.app.use('/api/evolution', require('../routes/evolution.route'));
        this.app.use('/api/exam', require('../routes/exam.route'));
        this.app.use('/api/gender', require('../routes/gender.route'));
        this.app.use('/api/habits', require('../routes/habits.route'));
        this.app.use('/api/generator-pdf', require('../routes/generatorPDF.route'));
        this.app.use('/api/license', require('../routes/license.route'));
        this.app.use('/api/medic', require('../routes/medic.route'));
        this.app.use('/api/organSystem', require('../routes/organ.route'));
        this.app.use('/api/pathological', require('../routes/pathological.route'));
        this.app.use('/api/patient', require('../routes/patient.route'));
        this.app.use('/api/patientByAttention', require('../routes/report.route'));
        this.app.use('/api/plan', require('../routes/plan.route'));
        this.app.use('/api/prescription', require('../routes/prescription.route'));
        this.app.use('/api/product', require('../routes/product.route'));
        this.app.use('/api/psychologicalEvaluation', require('../routes/psychologicalEvaluation.route'));
        this.app.use('/api/reason', require('../routes/reasonC.route'));
        this.app.use('/api/record', require('../routes/record.route'));
        this.app.use('/api/role',require('../routes/role.route'));
        this.app.use('/api/sex', require('../routes/sex.route'));
        this.app.use('/api/sexual', require('../routes/sexual.route'));
        this.app.use('/api/tooth', require('../routes/tooth.route'));
        this.app.use('/api/totalAttention', require('../routes/totalAttention.route'));
        this.app.use('/api/typeExam', require('../routes/typeExam.route'));
        this.app.use('/api/typeId', require('../routes/typeID.route'));
        this.app.use('/api/typeLicense', require('../routes/typeLicense.route'));
        this.app.use('/api/types', require('../routes/types.route'));
        this.app.use('/api/user', require('../routes/user.route'));
        this.app.use('/api/vitalSigns', require('../routes/vitalSigns.route'));
        this.app.use('/api/consultaGAP', require('../routes/api_not_ssl.route'));
    }

    
    listen(){
        this.app.listen(this.port, () => {
            console.log('Corriendo por el puerto:', this.port);

        });
    }
}

module.exports = Server;