const {Router} = require('express');
const { getCustomer, postCustomer } = require('../controllers/customer.controller');
const { validateJWT } = require('../middlewares/validate-JWT');


const router = Router();
/* *************************************************************** */
/* **********************Services GET***************************** */

  router.get('/:id', validateJWT, getCustomer);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

  router.post('/', validateJWT, postCustomer);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

  // router.put('/:id', Object);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

  // router.delete('/:id', Object);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = router;
/* *************************************************************** */
/* *************************************************************** */