const {Router} = require('express');
const { postDiary, getDiary, getDiaryID, putDiary, getPatientCita, confirmationDiary, confirmationReschedule } = require('../controllers/diary.controller');
const { validateJWT } = require('../middlewares/validate-JWT');


const router = Router();
/* *************************************************************** */
/* **********************Services GET***************************** */

router.get('/', validateJWT, getDiary);
router.get('/:id', validateJWT, getDiaryID);
router.get('/cita/:id', validateJWT, getPatientCita);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

  router.post('/', validateJWT, postDiary);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

  router.put('/', putDiary);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

  router.delete('/:id', confirmationDiary);
  router.delete('/reschedule/:id', confirmationReschedule);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = router;
/* *************************************************************** */
/* *************************************************************** */