const {Router} = require('express');
const { getPatient, getPatientByPk, postPatient, putPatient, deletePatient, getPatientByNameID } = require('../controllers/patient.controller');
const { validateJWT } = require('../middlewares/validate-JWT');


const router = Router();
/* *************************************************************** */
/* **********************Services GET***************************** */

  router.get('/', validateJWT, getPatient);
  router.get('/:id', getPatientByPk);
  router.get('/like/:id', getPatientByNameID);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

  router.post('/', validateJWT, postPatient);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

  router.put('/:id', validateJWT, putPatient);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

  router.delete('/:id', validateJWT, deletePatient);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = router;
/* *************************************************************** */
/* *************************************************************** */