const {Router} = require('express');
const { getProductsByCompany, postProduct, putProduct, deleteProduct, getProductByPk, getProductsByCompanyLike } = require('../controllers/product.controller');
const { validateJWT } = require('../middlewares/validate-JWT');


const router = Router();
/* *************************************************************** */
/* **********************Services GET***************************** */

  router.get('/', validateJWT, getProductsByCompany);
  router.get('/:id', validateJWT, getProductByPk);
  router.get('/like/:id', validateJWT, getProductsByCompanyLike);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

  router.post('/', validateJWT, postProduct);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

  router.put('/:id', validateJWT, putProduct);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

  router.delete('/:id', validateJWT, deleteProduct);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = router;
/* *************************************************************** */
/* *************************************************************** */