const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Attention', {
    id_attention: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_patient: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_company: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    observation: {
      type: DataTypes.STRING(300),
      allowNull: false,
      defaultValue: "",
      comment: "campo con la finalidad de ingresar un comentario que sera visto por el médico para recordar algo importante de esa atención."
    },
    status_attention: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Attention',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_attention" },
        ]
      },
      {
        name: "FK_patient_id_patient",
        using: "BTREE",
        fields: [
          { name: "id_patient" },
        ]
      },
      {
        name: "FK_company_id_company",
        using: "BTREE",
        fields: [
          { name: "id_company" },
        ]
      },
      {
        name: "FK_user_id_user",
        using: "BTREE",
        fields: [
          { name: "id_user" },
        ]
      },
    ]
  });
};
