const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Bill', {
    id_bill: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_box: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_attention: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_customer: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_type_id: {
      type: DataTypes.SMALLINT,
      allowNull: false
    },
    number_document: {
      type: DataTypes.STRING(9),
      allowNull: false,
      comment: "Número de secuencia con el que va salir la factura"
    },
    business_name: {
      type: DataTypes.STRING(300),
      allowNull: false,
      comment: "Razón social de la persona o empresa a la que se va facturar"
    },
    email: {
      type: DataTypes.STRING(300),
      allowNull: false,
      comment: "Correo electrónico a donde debe llegar la factura electrónica"
    },
    phone: {
      type: DataTypes.STRING(300),
      allowNull: false,
      comment: "Número de teléfono que se guarda en la factura"
    },
    address_bill: {
      type: DataTypes.STRING(300),
      allowNull: false,
      comment: "Dirección de la persona o empresa que se va facturar"
    },
    subtotal: {
      type: DataTypes.DECIMAL(18,4),
      allowNull: false,
      comment: "El valor Total sin descuento ni impuestos"
    },
    discount: {
      type: DataTypes.DECIMAL(18,4),
      allowNull: false,
      comment: "El descuento total que se emite en la factura"
    },
    total_iva: {
      type: DataTypes.DECIMAL(18,4),
      allowNull: false,
      comment: "El valor total que paga impuestos"
    },
    total_not_iva: {
      type: DataTypes.DECIMAL(18,4),
      allowNull: false,
      comment: "El valor total que no paga impuestos"
    },
    iva: {
      type: DataTypes.DECIMAL(18,4),
      allowNull: false,
      comment: "El valor total del impuesto"
    },
    total: {
      type: DataTypes.DECIMAL(18,4),
      allowNull: false,
      comment: "El valor total a facturar"
    },
    status_box: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Bill',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_bill" },
        ]
      },
      {
        name: "FK_box_id_box",
        using: "BTREE",
        fields: [
          { name: "id_box" },
        ]
      },
      {
        name: "FK_customer_customer",
        using: "BTREE",
        fields: [
          { name: "id_customer" },
        ]
      },
      {
        name: "FK_typeID_id_type_id",
        using: "BTREE",
        fields: [
          { name: "id_type_id" },
        ]
      },
      {
        name: "FK_attention_id_attention",
        using: "BTREE",
        fields: [
          { name: "id_attention" },
        ]
      },
    ]
  });
};
