const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('CivilStatus', {
    id_civil_status: {
      autoIncrement: true,
      type: DataTypes.SMALLINT,
      allowNull: false,
      primaryKey: true
    },
    detail: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Nombre del estado civil de la persona"
    },
    description_civil_status: {
      type: DataTypes.STRING(300),
      allowNull: false,
      defaultValue: "",
      comment: "Detalle del estado civil"
    },
    status_civil_status: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'CivilStatus',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_civil_status" },
        ]
      },
    ]
  });
};
