const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Company', {
    id_company: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    business_name: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Razón social de la empresa que va facturar"
    },
    trade_name: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Es el nombre comercial que ocupa la empresa para realizar su facturación"
    },
    ruc: {
      type: DataTypes.STRING(20),
      allowNull: false,
      comment: "Número de identificación único de la empresa que entrega el estado"
    },
    matrix_address: {
      type: DataTypes.STRING(1000),
      allowNull: false,
      comment: "Dirección exacta donde está ubicada la empresa"
    },
    logo: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Dirección url del logo de la empresa"
    },
    obligatory_accounting: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 0,
      comment: "La empresa esta obligada a llevar contabilidad 0 falso 1 verdadero"
    },
    special_contributor: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 0,
      comment: "La empresa es contribuyente especial 0 falso 1 verdadero"
    },
    status_company: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Company',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_company" },
        ]
      },
    ]
  });
};
