const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('ConsultingRoom', {
    id_consulting: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_company: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    name_consulting: {
      type: DataTypes.STRING(500),
      allowNull: false,
      comment: "Nombre dado al consultorio perteneciente a un centro médico."
    },
    details: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Se detalla para que se puede ocupar y que no mas tiene equipado el consultorio."
    },
    status_consulting: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0."
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'ConsultingRoom',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_consulting" },
        ]
      },
      {
        name: "FK_company_id_company",
        using: "BTREE",
        fields: [
          { name: "id_company" },
        ]
      },
    ]
  });
};
