const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('DetailBill', {
    id_detail: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_product: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_bill: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    detail: {
      type: DataTypes.STRING(1500),
      allowNull: false,
      comment: "Detalle o nombre del producto"
    },
    price: {
      type: DataTypes.DECIMAL(18,4),
      allowNull: false,
      comment: "Precio unitario del producto"
    },
    discount: {
      type: DataTypes.DECIMAL(18,4),
      allowNull: false,
      comment: "Descuento unitario del producto"
    },
    total_quantity: {
      type: DataTypes.DECIMAL(18,4),
      allowNull: false,
      comment: "Cantidad total del producto"
    },
    total_price: {
      type: DataTypes.DECIMAL(18,4),
      allowNull: false,
      comment: "Precio total por cantidad del producto"
    },
    iva_total: {
      type: DataTypes.DECIMAL(18,4),
      allowNull: false,
      comment: "Iva total del producto"
    },
    status_detail: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'DetailBill',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_detail" },
        ]
      },
      {
        name: "FK_product_id_product",
        using: "BTREE",
        fields: [
          { name: "id_product" },
        ]
      },
      {
        name: "FK_bill_id_bill",
        using: "BTREE",
        fields: [
          { name: "id_bill" },
        ]
      },
    ]
  });
};
