const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Diagnosis', {
    id_diagnosis: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_attention: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    cie: {
      type: DataTypes.STRING(20),
      allowNull: false,
      comment: "Cie que determina el médico."
    },
    diagnosis: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Detalle del CIE que el médico determina como presuntivo o definitivo."
    },
    status_diagnosis: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado definitivo 1 presuntivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Diagnosis',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_diagnosis" },
        ]
      },
      {
        name: "FK_attention_id_attention",
        using: "BTREE",
        fields: [
          { name: "id_attention" },
        ]
      },
      {
        name: "FK_user_id_user",
        using: "BTREE",
        fields: [
          { name: "id_user" },
        ]
      },
    ]
  });
};
