const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Evolution', {
    id_evolution: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_attention: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    evolution: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Se ingresa las anotaciones de la evolución."
    },
    prescriptions: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Se ingresa las anotaciones de la prescripción."
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    status_evolution: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Evolution',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_evolution" },
        ]
      },
    ]
  });
};
