const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Patient', {
    id_patient: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_sex: {
      type: DataTypes.SMALLINT,
      allowNull: true
    },
    id_civil_status: {
      type: DataTypes.SMALLINT,
      allowNull: true
    },
    id_blood_typing: {
      type: DataTypes.SMALLINT,
      allowNull: true
    },
    id_sexual_orientation: {
      type: DataTypes.SMALLINT,
      allowNull: true
    },
    id_gender: {
      type: DataTypes.SMALLINT,
      allowNull: true
    },
    id_disability: {
      type: DataTypes.SMALLINT,
      allowNull: true,
      defaultValue: 0
    },
    disability_patient: {
      type: DataTypes.STRING(2000),
      allowNull: true,
      defaultValue: "",
      comment: "En el caso de tener discapacidad se detalla aquí el tipo y cualquier comentario"
    },
    agreement: {
      type: DataTypes.STRING(200),
      allowNull: false,
      defaultValue: "Sin Convenio",
      comment: "Determina si el paciente cuenta con algún tipo de seguro."
    },
    names_patient: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Nombres del paciente que se esta creando"
    },
    document_number: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Número de documento del paciente que se esta creando"
    },
    birthday: {
      type: DataTypes.DATEONLY,
      allowNull: false,
      comment: "Fecha de nacimiento del paciente que se esta creando"
    },
    email: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Correo electrónico del paciente que se esta creando"
    },
    address_patient: {
      type: DataTypes.STRING(2000),
      allowNull: false,
      comment: "Dirección de domicilio y referencia"
    },
    phone: {
      type: DataTypes.STRING(20),
      allowNull: false,
      comment: "Número de teléfono para poder localizar al paciente"
    },
    photo: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Url de la foto del paciente"
    },
    allergies: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Espacio para almacenar las alergias del paciente"
    },
    status_patient: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false,
      comment: "se registra el id del usuario que esta creando el registro"
    }
  }, {
    sequelize,
    tableName: 'Patient',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_patient" },
        ]
      },
      {
        name: "FK_sex_id_sex",
        using: "BTREE",
        fields: [
          { name: "id_sex" },
        ]
      },
      {
        name: "FK_civilStatus_id_civil_status",
        using: "BTREE",
        fields: [
          { name: "id_civil_status" },
        ]
      },
      {
        name: "FK_typePerson_id_blood_typing",
        using: "BTREE",
        fields: [
          { name: "id_blood_typing" },
        ]
      },
      {
        name: "FK_typePerson_id_sexual_orientation",
        using: "BTREE",
        fields: [
          { name: "id_sexual_orientation" },
        ]
      },
      {
        name: "FK_typePerson_id_gender",
        using: "BTREE",
        fields: [
          { name: "id_gender" },
        ]
      },
      {
        name: "FK_typePerson_id_disability",
        using: "BTREE",
        fields: [
          { name: "id_disability" },
        ]
      },
    ]
  });
};
