const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Patient_Cita', {
    id_patient_cita: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_diary: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    identity_card: {
      type: DataTypes.STRING(20),
      allowNull: false,
      comment: "Ingresa el número de cédula para ser atendido."
    },
    name_patient: {
      type: DataTypes.STRING(100),
      allowNull: false,
      comment: "Nombres y Apellidos del paciente para ser atendido"
    },
    date_birthday: {
      type: DataTypes.STRING(10),
      allowNull: false,
      comment: "fecha de nacimiento del paciente."
    },
    name_medic: {
      type: DataTypes.STRING(100),
      allowNull: false,
      comment: "Nombres y apellidos del médico que lo va atender"
    },
    consulting_room: {
      type: DataTypes.STRING(100),
      allowNull: false,
      comment: "Nombre del consultorio en el que va hacer atendido"
    },
    comments: {
      type: DataTypes.STRING(1000),
      allowNull: false,
      comment: "Se ingresa comentarios del paciente."
    },
    cellular_phone: {
      type: DataTypes.STRING(15),
      allowNull: false,
      comment: "Número de celular del paciente."
    },
    email: {
      type: DataTypes.STRING(50),
      allowNull: false,
      comment: "Se ingresa el correo electrónico del paciente"
    },
    confirmation: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 0,
      comment: "Si el paciente confirma su asistencia cambia a 1"
    },
    reschedule: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 0,
      comment: "Si el paciente reagenda su asistencia cambia a 1"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Patient_Cita',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_patient_cita" },
        ]
      },
      {
        name: "FK_diary_id_diary",
        using: "BTREE",
        fields: [
          { name: "id_diary" },
        ]
      },
    ]
  });
};
