const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Phone', {
    id_phone: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_medic: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_type: {
      type: DataTypes.SMALLINT,
      allowNull: false
    },
    phone: {
      type: DataTypes.STRING(500),
      allowNull: false,
      comment: "Referencia de la Dirección."
    },
    status_phone: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Phone',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_phone" },
        ]
      },
      {
        name: "FK_medic_id_medic",
        using: "BTREE",
        fields: [
          { name: "id_medic" },
        ]
      },
      {
        name: "FK_type_Phone_Medic_id_type",
        using: "BTREE",
        fields: [
          { name: "id_type" },
        ]
      },
    ]
  });
};
