const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('PsychologicalEvaluation', {
    id_psychological_evaluation: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_attention: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    assessment: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Se ingresa evaluación de funciones básicas y procesos cognitivos superiores."
    },
    clinical_evaluation: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Se ingresa las anotaciones de la evaluación clínica realizada por el profesional."
    },
    psychological_instruments: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Se ingresa las anotaciones de los instrumentos que el profesional ocupo en su consulta."
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'PsychologicalEvaluation',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_psychological_evaluation" },
        ]
      },
    ]
  });
};
