const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('ReasonConsultation', {
    id_reason_consultation: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_attention: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    reason: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Motivo por el cual asiste a chequeo médico."
    },
    disease: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Enfermedad o problema actual por el cual asiste a chequeo médico."
    },
    status_reason_consultation: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'ReasonConsultation',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_reason_consultation" },
        ]
      },
      {
        name: "FK_attention_id_attention",
        using: "BTREE",
        fields: [
          { name: "id_attention" },
        ]
      },
      {
        name: "FK_user_id_user",
        using: "BTREE",
        fields: [
          { name: "id_user" },
        ]
      },
    ]
  });
};
