const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('RecordSubsequentQueries', {
    id_record: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    name_patient: {
      type: DataTypes.STRING(100),
      allowNull: false,
      comment: "Nombre del paciente."
    },
    document_indent: {
      type: DataTypes.STRING(50),
      allowNull: false,
      comment: "Identificación del paciente."
    },
    Observations: {
      type: DataTypes.STRING(50),
      allowNull: false,
      comment: "Siempre en este campo se ingresa Consulta Subsecuente."
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'RecordSubsequentQueries',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_record" },
        ]
      },
    ]
  });
};
