const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('TypeExam', {
    id_exam: {
      autoIncrement: true,
      type: DataTypes.SMALLINT,
      allowNull: false,
      primaryKey: true
    },
    detail: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Nombre del examen que se crea"
    },
    status_exam: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false,
      comment: "se registra el id del usuario que esta creando el registro"
    }
  }, {
    sequelize,
    tableName: 'TypeExam',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_exam" },
        ]
      },
    ]
  });
};
