const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('TypeLicense', {
    id_type_license: {
      autoIncrement: true,
      type: DataTypes.SMALLINT,
      allowNull: false,
      primaryKey: true
    },
    detail: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Nombre de la licencia que se otorga al perfil del usuario para saver que tiempo y a donde va tener acceso"
    },
    description_type_license: {
      type: DataTypes.STRING(300),
      allowNull: false,
      defaultValue: "",
      comment: "Detalle define el tipo de licencia que esta comprando la persona para poder tener acceso a la plataforma"
    },
    status_type_license: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'TypeLicense',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_type_license" },
        ]
      },
    ]
  });
};
