const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('VitalSigns', {
    id_vital_signs: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_attention: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    temperature: {
      type: DataTypes.DECIMAL(18,2),
      allowNull: true,
      comment: "Valor de temperatura que el paciente tiene en la consulta."
    },
    bloodPressureA: {
      type: DataTypes.SMALLINT,
      allowNull: true,
      comment: "Valor de presión sistólica."
    },
    bloodPressureB: {
      type: DataTypes.SMALLINT,
      allowNull: true,
      comment: "Valor de presión diastólica."
    },
    pulse: {
      type: DataTypes.DECIMAL(18,2),
      allowNull: true,
      comment: "Valor del pulso que registra el paciente."
    },
    breathingFrequency: {
      type: DataTypes.SMALLINT,
      allowNull: true,
      comment: "Valor de frecuencia respiratoria que tiene el paciente."
    },
    weight: {
      type: DataTypes.DECIMAL(18,2),
      allowNull: true,
      comment: "Peso que registra el paciente."
    },
    size: {
      type: DataTypes.DECIMAL(18,2),
      allowNull: true,
      comment: "Talla que registra el paciente."
    },
    imc: {
      type: DataTypes.DECIMAL(18,2),
      allowNull: true,
      comment: "Indice de masa corporal que registra el paciente."
    },
    abdominalPerimeter: {
      type: DataTypes.DECIMAL(18,2),
      allowNull: true,
      comment: "Valor del perímetro del abdomen que registra el paciente."
    },
    hemoglobin: {
      type: DataTypes.DECIMAL(18,2),
      allowNull: true,
      comment: "Valor de la hemoglobina que registra el paciente."
    },
    glucose: {
      type: DataTypes.DECIMAL(18,2),
      allowNull: true,
      comment: "Valor de la glucosa que registra el paciente."
    },
    pulsioximetria: {
      type: DataTypes.SMALLINT,
      allowNull: true,
      comment: "Valor de la pulsioximetría que registra el paciente."
    },
    status_vital_signs: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'VitalSigns',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_vital_signs" },
        ]
      },
      {
        name: "FK_attention_id_attention",
        using: "BTREE",
        fields: [
          { name: "id_attention" },
        ]
      },
      {
        name: "FK_user_id_user",
        using: "BTREE",
        fields: [
          { name: "id_user" },
        ]
      },
    ]
  });
};
